/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.models;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.betterx.betterend.BetterEnd;

public class Patterns {
    public static final ResourceLocation BLOCK_EMPTY = BetterEnd.makeID("patterns/block/empty.json");
    public static final ResourceLocation BLOCK_BASE = BetterEnd.makeID("patterns/block/block.json");
    public static final ResourceLocation BLOCK_SIDED = BetterEnd.makeID("patterns/block/block_sided.json");
    public static final ResourceLocation BLOCK_BOTTOM_TOP = BetterEnd.makeID("patterns/block/block_bottom_top.json");
    public static final ResourceLocation BLOCK_SLAB = BetterEnd.makeID("patterns/block/slab.json");
    public static final ResourceLocation BLOCK_STAIR = BetterEnd.makeID("patterns/block/stairs.json");
    public static final ResourceLocation BLOCK_STAIR_INNER = BetterEnd.makeID("patterns/block/inner_stairs.json");
    public static final ResourceLocation BLOCK_STAIR_OUTER = BetterEnd.makeID("patterns/block/outer_stairs.json");
    public static final ResourceLocation BLOCK_WALL_POST = BetterEnd.makeID("patterns/block/wall_post.json");
    public static final ResourceLocation BLOCK_WALL_SIDE = BetterEnd.makeID("patterns/block/wall_side.json");
    public static final ResourceLocation BLOCK_WALL_SIDE_TALL = BetterEnd.makeID("patterns/block/wall_side_tall.json");
    public static final ResourceLocation BLOCK_FENCE_POST = BetterEnd.makeID("patterns/block/fence_post.json");
    public static final ResourceLocation BLOCK_FENCE_SIDE = BetterEnd.makeID("patterns/block/fence_side.json");
    public static final ResourceLocation BLOCK_BUTTON = BetterEnd.makeID("patterns/block/button.json");
    public static final ResourceLocation BLOCK_BUTTON_PRESSED = BetterEnd.makeID("patterns/block/button_pressed.json");
    public static final ResourceLocation BLOCK_PILLAR = BetterEnd.makeID("patterns/block/pillar.json");
    public static final ResourceLocation BLOCK_PLATE_UP = BetterEnd.makeID("patterns/block/pressure_plate_up.json");
    public static final ResourceLocation BLOCK_PLATE_DOWN = BetterEnd.makeID("patterns/block/pressure_plate_down.json");
    public static final ResourceLocation BLOCK_DOOR_TOP = BetterEnd.makeID("patterns/block/door_top.json");
    public static final ResourceLocation BLOCK_DOOR_TOP_HINGE = BetterEnd.makeID("patterns/block/door_top_hinge.json");
    public static final ResourceLocation BLOCK_DOOR_BOTTOM = BetterEnd.makeID("patterns/block/door_bottom.json");
    public static final ResourceLocation BLOCK_DOOR_BOTTOM_HINGE = BetterEnd.makeID("patterns/block/door_bottom_hinge.json");
    public static final ResourceLocation BLOCK_CROSS = BetterEnd.makeID("patterns/block/cross.json");
    public static final ResourceLocation BLOCK_CROSS_SHADED = BetterEnd.makeID("patterns/block/cross_shaded.json");
    public static final ResourceLocation BLOCK_GATE_CLOSED = BetterEnd.makeID("patterns/block/fence_gate_closed.json");
    public static final ResourceLocation BLOCK_GATE_CLOSED_WALL = BetterEnd.makeID("patterns/block/wall_gate_closed.json");
    public static final ResourceLocation BLOCK_GATE_OPEN = BetterEnd.makeID("patterns/block/fence_gate_open.json");
    public static final ResourceLocation BLOCK_GATE_OPEN_WALL = BetterEnd.makeID("patterns/block/wall_gate_open.json");
    public static final ResourceLocation BLOCK_TRAPDOOR = BetterEnd.makeID("patterns/block/trapdoor.json");
    public static final ResourceLocation BLOCK_LADDER = BetterEnd.makeID("patterns/block/ladder.json");
    public static final ResourceLocation BLOCK_BARREL_OPEN = BetterEnd.makeID("patterns/block/barrel_open.json");
    public static final ResourceLocation BLOCK_PEDESTAL_DEFAULT = BetterEnd.makeID("patterns/block/pedestal_default.json");
    public static final ResourceLocation BLOKC_PEDESTAL_COLUMN = BetterEnd.makeID("patterns/block/pedestal_column.json");
    public static final ResourceLocation BLOCK_PEDESTAL_COLUMN_TOP = BetterEnd.makeID("patterns/block/pedestal_column_top.json");
    public static final ResourceLocation BLOCK_PEDESTAL_TOP = BetterEnd.makeID("patterns/block/pedestal_top.json");
    public static final ResourceLocation BLOCK_PEDESTAL_BOTTOM = BetterEnd.makeID("patterns/block/pedestal_bottom.json");
    public static final ResourceLocation BLOCK_PEDESTAL_PILLAR = BetterEnd.makeID("patterns/block/pedestal_pillar.json");
    public static final ResourceLocation BLOCK_BOOKSHELF = BetterEnd.makeID("patterns/block/bookshelf.json");
    public static final ResourceLocation BLOCK_STONE_LANTERN_CEIL = BetterEnd.makeID("patterns/block/stone_lantern_ceil.json");
    public static final ResourceLocation BLOCK_STONE_LANTERN_FLOOR = BetterEnd.makeID("patterns/block/stone_lantern_floor.json");
    public static final ResourceLocation BLOCK_BULB_LANTERN_FLOOR = BetterEnd.makeID("patterns/block/bulb_lantern_floor.json");
    public static final ResourceLocation BLOCK_BULB_LANTERN_CEIL = BetterEnd.makeID("patterns/block/bulb_lantern_ceil.json");
    public static final ResourceLocation BLOCK_PETAL_COLORED = BetterEnd.makeID("models/block/block_petal_colored.json");
    public static final ResourceLocation BLOCK_COMPOSTER = BetterEnd.makeID("patterns/block/composter.json");
    public static final ResourceLocation BLOCK_COLORED = BetterEnd.makeID("patterns/block/block_colored.json");
    public static final ResourceLocation BLOCK_BARS_POST = BetterEnd.makeID("patterns/block/bars_post.json");
    public static final ResourceLocation BLOCK_BARS_SIDE = BetterEnd.makeID("patterns/block/bars_side.json");
    public static final ResourceLocation BLOCK_ANVIL = BetterEnd.makeID("patterns/block/anvil.json");
    public static final ResourceLocation BLOCK_CHAIN = BetterEnd.makeID("patterns/block/chain.json");
    public static final ResourceLocation BLOCK_CHANDELIER_FLOOR = BetterEnd.makeID("patterns/block/chandelier_floor.json");
    public static final ResourceLocation BLOCK_CHANDELIER_WALL = BetterEnd.makeID("patterns/block/chandelier_wall.json");
    public static final ResourceLocation BLOCK_CHANDELIER_CEIL = BetterEnd.makeID("patterns/block/chandelier_ceil.json");
    public static final ResourceLocation BLOCK_FURNACE = BetterEnd.makeID("patterns/block/furnace.json");
    public static final ResourceLocation BLOCK_FURNACE_LIT = BetterEnd.makeID("patterns/block/furnace_glow.json");
    public static final ResourceLocation BLOCK_TOP_SIDE_BOTTOM = BetterEnd.makeID("patterns/block/top_side_bottom.json");
    public static final ResourceLocation BLOCK_PATH = BetterEnd.makeID("patterns/block/path.json");
    public static final ResourceLocation BLOCK_FLOWER_POT = BetterEnd.makeID("patterns/block/flower_pot.json");
    public static final ResourceLocation BLOCK_FLOWER_POT_SOIL = BetterEnd.makeID("patterns/block/flower_pot_soil.json");
    public static final ResourceLocation BLOCK_POTTED_LEAVES = BetterEnd.makeID("patterns/block/potted_leaves.json");
    public static final ResourceLocation ITEM_WALL = BetterEnd.makeID("patterns/item/pattern_wall.json");
    public static final ResourceLocation ITEM_FENCE = BetterEnd.makeID("patterns/item/pattern_fence.json");
    public static final ResourceLocation ITEM_BUTTON = BetterEnd.makeID("patterns/item/pattern_button.json");
    public static final ResourceLocation ITEM_CHEST = BetterEnd.makeID("patterns/item/pattern_chest.json");
    public static final ResourceLocation ITEM_BLOCK = BetterEnd.makeID("patterns/item/pattern_block_item.json");
    public static final ResourceLocation ITEM_GENERATED = BetterEnd.makeID("patterns/item/pattern_item_generated.json");
    public static final ResourceLocation ITEM_HANDHELD = BetterEnd.makeID("patterns/item/pattern_item_handheld.json");
    public static final ResourceLocation ITEM_SPAWN_EGG = BetterEnd.makeID("patterns/item/pattern_item_spawn_egg.json");

    public static Optional<String> createItemGenerated(String name) {
        return Patterns.createJson(ITEM_GENERATED, name);
    }

    public static Optional<String> createBlockSimple(String name) {
        return Patterns.createJson(BLOCK_BASE, name, name);
    }

    public static Optional<String> createBlockPillar(String name) {
        return Patterns.createJson(BLOCK_PILLAR, name, name);
    }

    public static String createJson(Reader data, String parent, String block) {
        String string;
        BufferedReader buffer = new BufferedReader(data);
        try {
            string = buffer.lines().collect(Collectors.joining()).replace("%parent%", parent).replace("%block%", block);
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return null;
            }
        }
        buffer.close();
        return string;
    }

    public static Optional<String> createJson(ResourceLocation patternId, String parent, String block) {
        Optional<String> optional;
        block8: {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            InputStream input = ((Resource)resourceManager.m_213713_(patternId).get()).m_215507_();
            try {
                optional = Optional.ofNullable(Patterns.createJson(new InputStreamReader(input, StandardCharsets.UTF_8), parent, block));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return Optional.empty();
                }
            }
            input.close();
        }
        return optional;
    }

    public static Optional<String> createJson(ResourceLocation patternId, String texture) {
        HashMap textures = Maps.newHashMap();
        textures.put("%texture%", texture);
        return Patterns.createJson(patternId, textures);
    }

    public static Optional<String> createJson(ResourceLocation patternId, Map<String, String> textures) {
        Optional<String> optional;
        block9: {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            InputStream input = ((Resource)resourceManager.m_213713_(patternId).get()).m_215507_();
            try {
                String json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining());
                for (Map.Entry<String, String> texture : textures.entrySet()) {
                    json = json.replace(texture.getKey(), texture.getValue());
                }
                optional = Optional.of(json);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return Optional.empty();
                }
            }
            input.close();
        }
        return optional;
    }
}

